* Definicia mnozin
Set i /1*46/
    w1 /RAS,OLD/,
    w2 /A,B,C,D,E,F/;

alias(i,j);

* Definicia parametrov
Parameter A1(i,j),B1(i,j),y1(i),x1(j),u1(i),v1(j),
          A0(i,j),B0(i,j),y0(i),x0(j),u0(i),v0(j),
          MAD_A(w1,w2),SEM_A(w1,w2),
          MAD_B(w1,w2),SEM_B(w1,w2),
          MaxPE(w1,w2),MAPE(w1,w2),
          GOF_A(w1,w2),GOF_B(w1,w2),
          CORR_A(w1,w2),CORR_B(w1,w2),
          mean_A1_HAT(w1,w2),mean_A1,
          mean_B1_HAT(w1,w2),mean_B1,
          mean0,mean1,
          stddev0,stddev1;

$libinclude xlimport B0 C:\MaxEnt\Data\IO-96-98.xls IO96inputAGG00!a1:au48
$libinclude xlimport x0 C:\MaxEnt\Data\IO-96-98.xls IO96inputAGG00!a49:au50
$libinclude xlimport B1 C:\MaxEnt\Data\IO-96-98.xls IO98inputAGG00!a1:au48
$libinclude xlimport x1 C:\MaxEnt\Data\IO-96-98.xls IO98inputAGG00!a49:au50

    B0(i,j)=B0(i,j)/1000;
    B1(i,j)=B1(i,j)/1000;
    x0(j)=x0(j)/1000;
    x1(j)=x1(j)/1000;

Scalar G,N1;
    N1=sum((i,j), 1);

Parameter A1_HAT(i,j,w1,w2),B1_HAT(i,j,w1,w2),
          R(i),S(j),
          E_A(i,j,w1,w2),
          E_B(i,j,w1,w2),
          P_B(i,j,w1,w2);

Parameter e(w2);
    e('A')=0.01;
    e('B')=0.005;
    e('C')=0.001;
    e('D')=0.0005;
    e('E')=0.0001;
    e('F')=0.00005;

*    B0(i,j)=2;
*    B1('1','1')=2.5;
*    B1('1','2')=1.5;
*    B1('2','1')=7.5;
*    B1('2','2')=4.5;

    u0(i)=sum(j, B0(i,j));
    v0(j)=sum(i, B0(i,j));
*    x0(j)=v0(j);

    A0(i,j)=B0(i,j)/x0(j);

    u1(i)=sum(j, B1(i,j));
    v1(j)=sum(i, B1(i,j));
*    x1(j)=v1(j);

    A1(i,j)=B1(i,j)/x1(j);

    A1_HAT(i,j,w1,w2)=A0(i,j);

* RAS procedura
    loop(w2,

         while(
                smax(i, abs(u1(i)-sum(j, A1_HAT(i,j,'RAS',w2)*x1(j))))>e(w2)
             or smax(j, abs(v1(j)/x1(j)-sum(i, A1_HAT(i,j,'RAS',w2))))>e(w2),

             if (smax(i, abs(u1(i)-sum(j, A1_HAT(i,j,'RAS',w2)*x1(j))))>e(w2),
                 R(i)=u1(i)/sum(j, A1_HAT(i,j,'RAS',w2)*x1(j));
                 loop(j, A1_HAT(i,j,'RAS',w2)=A1_HAT(i,j,'RAS',w2)*R(i));
                 )
             if (smax(j, abs(v1(j)/x1(j)-sum(i, A1_HAT(i,j,'RAS',w2))))>e(w2),
                 S(j)=v1(j)/x1(j)/sum(i, A1_HAT(i,j,'RAS',w2));
                 loop(i, A1_HAT(i,j,'RAS',w2)=A1_HAT(i,j,'RAS',w2)*S(j));
                 )
              );

         B1_HAT(i,j,w1,w2)=A1_HAT(i,j,w1,w2)*x1(j);

         E_A(i,j,w1,w2) = A1_HAT(i,j,w1,w2)-A1(i,j);
         E_B(i,j,w1,w2) = B1_HAT(i,j,w1,w2)-B1(i,j);
         P_B(i,j,w1,w2)$B1(i,j) = abs(E_B(i,j,w1,w2))/B1(i,j);

         MAD_A(w1,w2) = sum((i,j), abs(E_A(i,j,w1,w2)))/N1;
         SEM_A(w1,w2) = sum((i,j), power(E_A(i,j,w1,w2),2))/N1;

         MAD_B(w1,w2) = sum((i,j), abs(E_B(i,j,w1,w2)))/N1;
         SEM_B(w1,w2) = sum((i,j), power(E_B(i,j,w1,w2),2))/N1;

         MaxPE(w1,w2) = smax((i,j), P_B(i,j,w1,w2));
         MAPE(w1,w2) = sum((i,j), P_B(i,j,w1,w2))/N1;

         GOF_A(w1,w2) = sum((i,j)$A1_HAT(i,j,w1,w2), E_A(i,j,w1,w2)*E_A(i,j,w1,w2)/(N1*A1_HAT(i,j,w1,w2)));
         mean_A1_HAT(w1,w2)=sum((i,j), A1_HAT(i,j,w1,w2))/N1;
         mean_A1=sum((i,j), A1(i,j))/N1;
         CORR_A(w1,w2) = (sum((i,j),(A1_HAT(i,j,w1,w2)-mean_A1_HAT(w1,w2))*(A1(i,j)-mean_A1))/N1)/
           ((sum((i,j),power(A1_HAT(i,j,w1,w2)-mean_A1_HAT(w1,w2),2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5;

         GOF_B(w1,w2) = sum((i,j)$B1_HAT(i,j,w1,w2), E_B(i,j,w1,w2)*E_B(i,j,w1,w2)/(N1*B1_HAT(i,j,w1,w2)));
         mean_B1_HAT(w1,w2)=sum((i,j), B1_HAT(i,j,w1,w2))/N1;
         mean_B1=sum((i,j), B1(i,j))/N1;
         CORR_B(w1,w2) = (sum((i,j),(B1_HAT(i,j,w1,w2)-mean_B1_HAT(w1,w2))*(B1(i,j)-mean_B1))/N1)/
           ((sum((i,j),power(B1_HAT(i,j,w1,w2)-mean_B1_HAT(w1,w2),2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5;

         mean0=sum((i,j), B0(i,j))/N1;
         mean1=sum((i,j), B1(i,j))/N1;
         stddev0=sum((i,j), power((B0(i,j)-mean0),2))/N1;
         stddev1=sum((i,j), power((B1(i,j)-mean1),2))/N1;
        );

option decimals = 5

Display MAD_A,SEM_A,
        MAD_B,SEM_B,
        MaxPE,MAPE,
        GOF_A,GOF_B,
        CORR_A,CORR_B,
        mean0,mean1,
        stddev0,stddev1;

*Display A1_HAT;